using System;
using System.Collections.Generic;
using System.Linq;
using System.Web.UI;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.Business;
using System.Web.Security.AntiXss;

public partial class FragLabInterpretation : BasePage
{
    private readonly LabResultsIntrprtnManager LabIntrptnMgr;
    private WKF_CASE WCase;
    private WKF_CASE_ACTIVITY Activity;
    private EFR_REFERRAL Referral;
    private PATIENT Patient;
    private STD_WKFACTIVITYST ActivitySt;

    private static IReadOnlyList<string> _navigationSources = new List<string>
    {
        "/LabResultsInterpretation.aspx",
        "/LabResultsInterpretationLetters.aspx",
        "/PatientWorkflows.aspx"
    };

    public FragLabInterpretation()
    {
        LabIntrptnMgr = new LabResultsIntrprtnManager();

        //Manager Save Notification Event Handler
        LabIntrptnMgr.BOSaveSuccess += new BaseBO.BOSaveSuccessEvent(manager_BOSaveSuccess);

        NavigationSources = _navigationSources;
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        int CaseId;
        LabResultInterpretation1.OnCancelClick += LabResultInterpretation1_OnCancelClick;
        LabResultInterpretation1.OnSaveClick += LabResultInterpretation1_OnSaveClick;
        LabResultInterpretation1.OnInterpretComplete += LabResultInterpretation1_OnInterpretComplete;
        LabResultInterpretation1.OnPrintPatientLetter += LabResultInterpretation1_OnPrintPatientLetter;
        LabResultInterpretation1.OnPrintProviderLetter += LabResultInterpretation1_OnPrintProviderLetter;
        LabResultInterpretation1.OnAddPrintQueue += LabResultInterpretation1_OnAddPrintQueue;

        if (!IsPostBack)
        {
            CaseId = Convert.ToInt32(AntiXssEncoder.HtmlEncode(Request.QueryString["CaseId"], false));
            BindData(CaseId);

            SetReferringPage();
        }
    }

    void LabResultInterpretation1_OnPrintProviderLetter(object sender, EventArgs e)
    {
        Deserialize();
        if (GetInterpretationActivity().STD_WKFACTIVITYSTS_ID != Convert.ToInt16(WorkflowCaseActivityStatus.Interpreted)) SaveData();
        Response.Redirect(string.Format("LabResultsInterpretationLetters.aspx?activityId={0}&intActivityId={1}&RptType={2}&CaseId={3}", GetLabResult().WKF_CASE_ACTIVITY_ID, GetInterpretationActivity().WKF_CASE_ACTIVITY_ID, "1", WCase.WKF_CASE_ID));
    }

    void LabResultInterpretation1_OnPrintPatientLetter(object sender, EventArgs e)
    {
        Deserialize();
        if (GetInterpretationActivity().STD_WKFACTIVITYSTS_ID != Convert.ToInt16(WorkflowCaseActivityStatus.Interpreted)) SaveData();
        Response.Redirect(string.Format("LabResultsInterpretationLetters.aspx?activityId={0}&intActivityId={1}&RptType={2}&CaseId={3}", GetLabResult().WKF_CASE_ACTIVITY_ID, GetInterpretationActivity().WKF_CASE_ACTIVITY_ID, "0", WCase.WKF_CASE_ID));
    }

    void LabResultInterpretation1_OnAddPrintQueue(object sender, EventArgs e)
    {
        Deserialize();
        WKF_CASE_ACTIVITY intActivity = WCase.WKF_CASE_ACTIVITies.Where(s => s.STD_WKFACTIVITYTYPE_ID == Convert.ToInt16(WorkFlowActivityTypes.Interpretation)
            && s.ARCHIVED_FLAG == false).FirstOrDefault();
        if (intActivity.STD_WKFACTIVITYSTS_ID != Convert.ToInt16(WorkflowCaseActivityStatus.Interpreted)) SaveData();
        if (intActivity != null && intActivity.INTERPRETATION_LETTERs.Count() > 0)
        {
            LabIntrptnMgr.UpdateInterpretationLetterPrintQueue(intActivity.INTERPRETATION_LETTERs[0], true);
        }
    }

    private void BindData(int caseId)
    {
        WCase = LabIntrptnMgr.GetLabInterpretationDetails(caseId);
        Activity = GetLabResult();
        ViewState["WCase"] = WCase.Serialize();
        ViewState["Referral"] = WCase.REFERRAL.Serialize();
        ViewState["Patient"] = WCase.REFERRAL.PATIENT.Serialize();

        WKF_CASE_ACTIVITY order = GetLabOrder();

        FragLabResult1.BindData(Activity, order, true);
        //FragLabResult1.BindData(WCase, true); 
        //Bind provider,patient details
        //Populate patient updated address
        LabResultInterpretation1.PopulatePatientProviderDetails(WCase, "Fragment");

        WKF_CASE_ACTIVITY intActivity = WCase.WKF_CASE_ACTIVITies.Where(e => e.STD_WKFACTIVITYTYPE_ID == Convert.ToInt16(WorkFlowActivityTypes.Interpretation)
            && e.ARCHIVED_FLAG == false).Select(t => t).FirstOrDefault();
        ActivitySt = intActivity.STD_WKFACTIVITYST;
        ViewState["OrderType"] = ActivitySt.ID;

        BreadCrumbLabel.Text = "My Tasks > Interpretation & Follow Up > " + ActivitySt.NAME + " > Workflow ID " + WCase.WKF_CASE_ID;
    }
    void LabResultInterpretation1_OnInterpretComplete(object sender, EventArgs e)
    {
        Deserialize();
        Patient.SetAsChangeTrackingRoot(true);
        GetInterpretationActivity().STD_WKFACTIVITYSTS_ID = Convert.ToInt16(WorkflowCaseActivityStatus.Interpreted);

        OpenCloseReferralAndWorkflowCase(() => "Interpret");
        LabResultInterpretation1.UpdateInterpretationDetails(WCase);
        //Call update from the interpretation manager

        CONTACT_LOG contact = CreateNewContact();
        Patient.REFERRALs.Where(s => s.REFERRAL_ID == WCase.REFERRAL_ID).First().CONTACT_LOGs.Add(contact);

        LabIntrptnMgr.UpdateInterpretationActivity(Patient);

        var master = this.Master as RegistryMaster;
        if (master != null)
        {
            master.SetDirtyFlag(false);
        }
        //(this.Master as RegistryMaster).SetDirtyFlag(false);
        BindData(WCase.WKF_CASE_ID);

        WKF_CASE_ACTIVITY intActivity = WCase.WKF_CASE_ACTIVITies.Where(s => s.STD_WKFACTIVITYTYPE_ID == Convert.ToInt16(WorkFlowActivityTypes.Interpretation)
            && s.ARCHIVED_FLAG == false).Select(t => t).FirstOrDefault();
        if (intActivity != null && intActivity.INTERPRETATION_LETTERs.Count() > 0)
        {
            LabIntrptnMgr.UpdateInterpretationLetterPrintQueue(intActivity.INTERPRETATION_LETTERs[0], false);
        }
    }
    private WKF_CASE_ACTIVITY GetInterpretationActivity()
    {
        return WCase.WKF_CASE_ACTIVITies.Where(a => a.STD_WKFACTIVITYTYPE_ID == Convert.ToInt16(WorkFlowActivityTypes.Interpretation)
            && a.ARCHIVED_FLAG == false).FirstOrDefault();

    }
    void LabResultInterpretation1_OnSaveClick(object sender, EventArgs e)
    {
        if (Page.IsValid)
        {
            Deserialize();
            OpenCloseReferralAndWorkflowCase(() => "Save");
            SaveData();
            //lblSaveConfirmation.Visible = true;
            BindData(WCase.WKF_CASE_ID);

        }
    }

    private void SaveData()
    {
        Deserialize();
        Patient.SetAsChangeTrackingRoot(true);
        if (GetInterpretationActivity().STD_WKFACTIVITYSTS_ID != Convert.ToInt16(WorkflowCaseActivityStatus.Interpreted))
        {
            GetInterpretationActivity().STD_WKFACTIVITYSTS_ID = Convert.ToInt16(WorkflowCaseActivityStatus.InProcess);
        }
        //Check if the pre-populated patient address has been changed.
        LabResultInterpretation1.UpdateInterpretationDetails(WCase);
        //Call update from the interpretation manager
        LabIntrptnMgr.UpdateInterpretationActivity(Patient);
        var master = this.Master as RegistryMaster;
        if (master != null)
        {
            master.SetDirtyFlag(false);
        }
        //(this.Master as RegistryMaster).SetDirtyFlag(false);
    }
    private void Deserialize()
    {
        WCase = SerializerUtil.Deserialize<WKF_CASE>((string)ViewState["WCase"]);
        Referral = SerializerUtil.Deserialize<EFR_REFERRAL>((string)ViewState["Referral"]);
        Patient = SerializerUtil.Deserialize<PATIENT>((string)ViewState["Patient"]);
        WCase.REFERRAL = Referral;
        WCase.REFERRAL.PATIENT = Patient;
        Activity = GetLabResult();
    }

    private WKF_CASE_ACTIVITY GetLabResult()
    {
        return WCase.WKF_CASE_ACTIVITies.Where(e => e.STD_WKFACTIVITYTYPE_ID == Convert.ToInt16(WorkFlowActivityTypes.LabResult)
            && e.STD_WKFACTIVITYSTS_ID == Convert.ToInt16(WorkflowCaseActivityStatus.Accepted)
            && e.ARCHIVED_FLAG == false).Select(e => e).FirstOrDefault();

    }

    private WKF_CASE_ACTIVITY GetLabOrder()
    {
        return WCase.WKF_CASE_ACTIVITies.Where(e => e.STD_WKFACTIVITYTYPE_ID == Convert.ToInt16(WorkFlowActivityTypes.LabOrder) && e.ARCHIVED_FLAG == false).FirstOrDefault();


    }

    void LabResultInterpretation1_OnCancelClick(object sender, EventArgs e)
    {
        RedirectToReferringPage();
    }

    private void OpenCloseReferralAndWorkflowCase(Func<string> operation)
    {
        ReferralManager rm = new ReferralManager();

        EFR_REFERRAL parentReferral = rm.getReferralByReferralID(WCase.REFERRAL_ID.Value);

        if (operation() == "Interpret")
        {
            WCase.STD_WKFCASESTS_ID = (int)WorkFlowCaseStatus.Completed;
            var items = parentReferral.WKF_CASEs.Except(new List<WKF_CASE> { WCase }, new WorkflowCaseManager.WorkflowCaseComparer());



            if (items.Count(a => a.STD_WKFCASESTS_ID != (int)WorkFlowCaseStatus.Completed) == 0)

                Referral.STD_REFERRALSTS_ID = (int)ReferralStatus.Completed;
        }
        else
        {
            if (Referral.STD_REFERRALSTS_ID != (int)ReferralStatus.InProcess)
                Referral.STD_REFERRALSTS_ID = (int)ReferralStatus.InProcess;


            if (WCase.STD_WKFCASESTS_ID != (int)WorkFlowCaseStatus.InProcess)
                WCase.STD_WKFCASESTS_ID = (int)WorkFlowCaseStatus.InProcess;

        }
    }

    private CONTACT_LOG CreateNewContact()
    {

        CONTACT_LOG contact = new CONTACT_LOG();

        contact.REFERRAL_ID = WCase.REFERRAL_ID.Value;
        contact.CONTACT_FIRST_NAME = Patient.FIRST_NAME;
        contact.CONTACT_LAST_NAME = Patient.LAST_NAME;
        contact.CONTACT_DATE = DateTime.Now;
        contact.CONTACT_METHOD_TEXT = "Mail";
        contact.CONTACT_EMAIL = null;
        contact.CONTACT_ADDR1 = Patient.ADDRESS_LINE1;
        contact.CONTACT_ADDR2 = Patient.ADDRESS_LINE2;
        contact.CONTACT_ADDR3 = Patient.ADDRESS_LINE3;
        contact.CONTACT_CITY = Patient.CITY;
        contact.CONTACT_STATE = Patient.STATE;
        contact.CONTACT_POSTAL = Patient.POSTAL_CODE;
        contact.CONTACT_ZIPPLUS4 = Patient.ZIP_PLUS_4;
        contact.CONTACT_COUNTRY = Patient.COUNTRY;
        contact.CONTACT_REASON_TEXT = "Interpretation Letter Printed";
        contact.TELEMEDICINE_PATIENT_FLAG = false;
        contact.TELEMEDICINE_PROVIDER_FLAG = false;
        contact.INPATIENT_EVAL_RECOM_FLAG = false;
        contact.CONTACT_MESSAGE_TEXT = @"Interpretation Letter was printed by " +
            System.Threading.Thread.CurrentPrincipal.Identity.Name +
            @" The interpretation letter was sent to both the patient 
               indicated above, 
               and the provider as indicated on the interpretation screen.";

        return contact;
    }

    public override string TopMenuName()
    {
        return "My Tasks";
    }

    public override string MenuItemName()
    {
        return "EFR_LABINTERPRETATION";
    }

    public override string AppObjectCode()
    {
        return "EFR_LABINTERPRETATION";
    }
}
